package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagFrance: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇫🇷",
        description = "flag: France",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("flag-france", "france-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: France.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagFrance: Emoji get() = _FlagFrance

/**
 * Alias to emoji [FlagFrance] (Flags: country-flag: flag: France).
*/
public val Emoji.Companion.FranceFlag: Emoji get() = _FlagFrance
