package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagTuvalu: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇹🇻",
        description = "flag: Tuvalu",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-tuvalu", "tuvalu-flag"),
        emoticons = listOf(),
        notoImageRatio = 2.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Tuvalu.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagTuvalu: Emoji get() = _FlagTuvalu

/**
 * Alias to emoji [FlagTuvalu] (Flags: country-flag: flag: Tuvalu).
*/
public val Emoji.Companion.TuvaluFlag: Emoji get() = _FlagTuvalu
