package org.kodein.emoji.food_drink.drink

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Ice: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🧊",
        description = "ice",
        unicodeVersion = UnicodeVersion(12, 0),
        aliases = listOf("ice", "ice-cube"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Food & Drink: drink: ice.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Ice: Emoji get() = _Ice

/**
 * Alias to emoji [Ice] (Food & Drink: drink: ice).
*/
public val Emoji.Companion.IceCube: Emoji get() = _Ice
