package org.kodein.emoji.objects.household

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllHousehold() {
    add(intArrayOf(0x1f6aa), _Door)
    add(intArrayOf(0x1f6d7), _Elevator)
    add(intArrayOf(0x1fa9e), _Mirror)
    add(intArrayOf(0x1fa9f), _Window)
    add(intArrayOf(0x1f6cf, 0xfe0f), _Bed)
    add(intArrayOf(0x1f6cf), _Bed)
    add(intArrayOf(0x1f6cb, 0xfe0f), _CouchAndLamp)
    add(intArrayOf(0x1f6cb), _CouchAndLamp)
    add(intArrayOf(0x1fa91), _Chair)
    add(intArrayOf(0x1f6bd), _Toilet)
    add(intArrayOf(0x1faa0), _Plunger)
    add(intArrayOf(0x1f6bf), _Shower)
    add(intArrayOf(0x1f6c1), _Bathtub)
    add(intArrayOf(0x1faa4), _MouseTrap)
    add(intArrayOf(0x1fa92), _Razor)
    add(intArrayOf(0x1f9f4), _LotionBottle)
    add(intArrayOf(0x1f9f7), _SafetyPin)
    add(intArrayOf(0x1f9f9), _Broom)
    add(intArrayOf(0x1f9fa), _Basket)
    add(intArrayOf(0x1f9fb), _RollOfPaper)
    add(intArrayOf(0x1faa3), _Bucket)
    add(intArrayOf(0x1f9fc), _Soap)
    add(intArrayOf(0x1fae7), _Bubbles)
    add(intArrayOf(0x1faa5), _Toothbrush)
    add(intArrayOf(0x1f9fd), _Sponge)
    add(intArrayOf(0x1f9ef), _FireExtinguisher)
    add(intArrayOf(0x1f6d2), _ShoppingCart)
}

internal suspend fun SequenceScope<Emoji>.yieldAllHousehold() {
    yield(_Door)
    yield(_Elevator)
    yield(_Mirror)
    yield(_Window)
    yield(_Bed)
    yield(_CouchAndLamp)
    yield(_Chair)
    yield(_Toilet)
    yield(_Plunger)
    yield(_Shower)
    yield(_Bathtub)
    yield(_MouseTrap)
    yield(_Razor)
    yield(_LotionBottle)
    yield(_SafetyPin)
    yield(_Broom)
    yield(_Basket)
    yield(_RollOfPaper)
    yield(_Bucket)
    yield(_Soap)
    yield(_Bubbles)
    yield(_Toothbrush)
    yield(_Sponge)
    yield(_FireExtinguisher)
    yield(_ShoppingCart)
}

internal val countHousehold = 25

/**
 * All Emoji of the Objects: household subgroup.
*/
public fun Emoji.Companion.sequenceHousehold(): Sequence<Emoji> =
    sequence { yieldAllHousehold() }

/**
 * All Emoji of the Objects: household subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listHousehold(): List<Emoji> =
    ArrayList<Emoji>(countHousehold).also { list -> sequenceHousehold().forEach { list.add(it) } }

@Deprecated("Renamed listHousehold.", replaceWith = ReplaceWith("listHousehold()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allHousehold(): List<Emoji> =
    listHousehold()
