package org.kodein.emoji.objects.light_video

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _MagnifyingGlassTiltedLeft: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔍",
        description = "magnifying glass tilted left",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("magnifying-glass-tilted-left", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: light & video: magnifying glass tilted left.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.MagnifyingGlassTiltedLeft: Emoji get() = _MagnifyingGlassTiltedLeft
