package org.kodein.emoji.smileys_emotion.face_concerned

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _LoudlyCryingFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😭",
        description = "loudly crying face",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("loudly-crying-face", "loudly-crying"),
        emoticons = listOf(";_;"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-concerned: loudly crying face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.LoudlyCryingFace: Emoji get() = _LoudlyCryingFace

/**
 * Alias to emoji [LoudlyCryingFace] (Smileys & Emotion: face-concerned: loudly crying face).
*/
public val Emoji.Companion.LoudlyCrying: Emoji get() = _LoudlyCryingFace
