package org.kodein.emoji.smileys_emotion.face_concerned

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SlightlyFrowningFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🙁",
        description = "slightly frowning face",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("slightly-frowning-face", "frown"),
        emoticons = listOf(":("),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-concerned: slightly frowning face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SlightlyFrowningFace: Emoji get() = _SlightlyFrowningFace

/**
 * Alias to emoji [SlightlyFrowningFace] (Smileys & Emotion: face-concerned: slightly frowning face).
*/
public val Emoji.Companion.Frown: Emoji get() = _SlightlyFrowningFace
