package org.kodein.emoji.smileys_emotion.face_concerned

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _TiredFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😫",
        description = "tired face",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("tired-face", "distraught"),
        emoticons = listOf("D-X"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-concerned: tired face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.TiredFace: Emoji get() = _TiredFace

/**
 * Alias to emoji [TiredFace] (Smileys & Emotion: face-concerned: tired face).
*/
public val Emoji.Companion.Distraught: Emoji get() = _TiredFace
