package org.kodein.emoji.smileys_emotion.heart

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _BlueHeart: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "💙",
        description = "blue heart",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("blue-heart", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: heart: blue heart.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BlueHeart: Emoji get() = _BlueHeart
