package org.kodein.emoji.symbols.alphanum

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _BButtonBloodType: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🅱️",
        description = "B button (blood type)",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("b-button-blood-type-", "b-button", "blood-type-b"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: alphanum: B button (blood type).
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BButtonBloodType: Emoji get() = _BButtonBloodType

/**
 * Alias to emoji [BButtonBloodType] (Symbols: alphanum: B button (blood type)).
*/
public val Emoji.Companion.BButton: Emoji get() = _BButtonBloodType

/**
 * Alias to emoji [BButtonBloodType] (Symbols: alphanum: B button (blood type)).
*/
public val Emoji.Companion.BloodTypeB: Emoji get() = _BButtonBloodType
