package org.kodein.emoji.travel_places.place_map

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _MapOfJapan: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🗾",
        description = "map of Japan",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("map-of-japan", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Travel & Places: place-map: map of Japan.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.MapOfJapan: Emoji get() = _MapOfJapan
