package org.kodein.emoji.animals_nature.plant_other

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FourLeafClover: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🍀",
        description = "four leaf clover",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("four-leaf-clover", "luck"),
        emoticons = listOf(),
        notoAnimated = true,
    ),
)

/**
 * Emoji Animals & Nature: plant-other: four leaf clover.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FourLeafClover: Emoji get() = _FourLeafClover

/**
 * Alias to emoji [FourLeafClover] (Animals & Nature: plant-other: four leaf clover).
*/
public val Emoji.Companion.Luck: Emoji get() = _FourLeafClover
