package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagIndonesia: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇮🇩",
        description = "flag: Indonesia",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-indonesia", "indonesia-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Indonesia.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagIndonesia: Emoji get() = _FlagIndonesia

/**
 * Alias to emoji [FlagIndonesia] (Flags: country-flag: flag: Indonesia).
*/
public val Emoji.Companion.IndonesiaFlag: Emoji get() = _FlagIndonesia
