package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagMicronesia: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇫🇲",
        description = "flag: Micronesia",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-micronesia", "micronesia-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Micronesia.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagMicronesia: Emoji get() = _FlagMicronesia

/**
 * Alias to emoji [FlagMicronesia] (Flags: country-flag: flag: Micronesia).
*/
public val Emoji.Companion.MicronesiaFlag: Emoji get() = _FlagMicronesia
