package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagMongolia: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇲🇳",
        description = "flag: Mongolia",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-mongolia", "mongolia-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Mongolia.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagMongolia: Emoji get() = _FlagMongolia

/**
 * Alias to emoji [FlagMongolia] (Flags: country-flag: flag: Mongolia).
*/
public val Emoji.Companion.MongoliaFlag: Emoji get() = _FlagMongolia
