package org.kodein.emoji.objects.other_object

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _NazarAmulet: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🧿",
        description = "nazar amulet",
        unicodeVersion = UnicodeVersion(11, 0),
        aliases = listOf("nazar-amulet", "evil-eye"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: other-object: nazar amulet.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.NazarAmulet: Emoji get() = _NazarAmulet

/**
 * Alias to emoji [NazarAmulet] (Objects: other-object: nazar amulet).
*/
public val Emoji.Companion.EvilEye: Emoji get() = _NazarAmulet
