package org.kodein.emoji.objects.writing

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FountainPen: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🖋️",
        description = "fountain pen",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("fountain-pen", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: writing: fountain pen.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FountainPen: Emoji get() = _FountainPen
