package org.kodein.emoji.people_body.person_role

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PoliceOfficer: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "👮",
        description = "police officer",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("police-officer", "police"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person-role: police officer.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PoliceOfficer: SkinTone1Emoji get() = _PoliceOfficer

/**
 * Alias to emoji [PoliceOfficer] (People & Body: person-role: police officer).
*/
public val Emoji.Companion.Police: SkinTone1Emoji get() = _PoliceOfficer
