package org.kodein.emoji.people_body.person_sport

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PersonBiking: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🚴",
        description = "person biking",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("person-biking", "biking"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person-sport: person biking.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PersonBiking: SkinTone1Emoji get() = _PersonBiking

/**
 * Alias to emoji [PersonBiking] (People & Body: person-sport: person biking).
*/
public val Emoji.Companion.Biking: SkinTone1Emoji get() = _PersonBiking
