package org.kodein.emoji.smileys_emotion.face_concerned

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _AnguishedFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😧",
        description = "anguished face",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("anguished-face", "anguished"),
        emoticons = listOf(),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-concerned: anguished face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.AnguishedFace: Emoji get() = _AnguishedFace

/**
 * Alias to emoji [AnguishedFace] (Smileys & Emotion: face-concerned: anguished face).
*/
public val Emoji.Companion.Anguished: Emoji get() = _AnguishedFace
