package org.kodein.emoji.smileys_emotion.heart

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _HeartWithArrow: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "💘",
        description = "heart with arrow",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("heart-with-arrow", "cupid"),
        emoticons = listOf(),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: heart: heart with arrow.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.HeartWithArrow: Emoji get() = _HeartWithArrow

/**
 * Alias to emoji [HeartWithArrow] (Smileys & Emotion: heart: heart with arrow).
*/
public val Emoji.Companion.Cupid: Emoji get() = _HeartWithArrow
