package org.kodein.emoji.symbols.arrow

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _ClockwiseVerticalArrows: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔃",
        description = "clockwise vertical arrows",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("clockwise-vertical-arrows", "clockwise-arrows"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: arrow: clockwise vertical arrows.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ClockwiseVerticalArrows: Emoji get() = _ClockwiseVerticalArrows

/**
 * Alias to emoji [ClockwiseVerticalArrows] (Symbols: arrow: clockwise vertical arrows).
*/
public val Emoji.Companion.ClockwiseArrows: Emoji get() = _ClockwiseVerticalArrows
