package org.kodein.emoji.symbols.currency

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllCurrency() {
    add(intArrayOf(0x1f4b1), _CurrencyExchange)
    add(intArrayOf(0x1f4b2), _HeavyDollarSign)
}

internal fun MutableList<Emoji>.addAllCurrency() {
    add(_CurrencyExchange)
    add(_HeavyDollarSign)
}

/**
 * All Emoji of the Symbols: currency subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allCurrency(): List<Emoji> =
    ArrayList<Emoji>(2).apply { addAllCurrency() }
