package org.kodein.emoji.symbols.geometric

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SmallOrangeDiamond: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔸",
        description = "small orange diamond",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("small-orange-diamond", "diamond-orange-small"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: geometric: small orange diamond.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SmallOrangeDiamond: Emoji get() = _SmallOrangeDiamond

/**
 * Alias to emoji [SmallOrangeDiamond] (Symbols: geometric: small orange diamond).
*/
public val Emoji.Companion.DiamondOrangeSmall: Emoji get() = _SmallOrangeDiamond
