package org.kodein.emoji.travel_places.sky_weather

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _UmbrellaOnGround: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "⛱️",
        description = "umbrella on ground",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("umbrella-on-ground", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Travel & Places: sky & weather: umbrella on ground.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.UmbrellaOnGround: Emoji get() = _UmbrellaOnGround
