package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagAngola: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇦🇴",
        description = "flag: Angola",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-angola", "angola-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Angola.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagAngola: Emoji get() = _FlagAngola

/**
 * Alias to emoji [FlagAngola] (Flags: country-flag: flag: Angola).
*/
public val Emoji.Companion.AngolaFlag: Emoji get() = _FlagAngola
