package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagKyrgyzstan: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇰🇬",
        description = "flag: Kyrgyzstan",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-kyrgyzstan", "kyrgyzstan-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Kyrgyzstan.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagKyrgyzstan: Emoji get() = _FlagKyrgyzstan

/**
 * Alias to emoji [FlagKyrgyzstan] (Flags: country-flag: flag: Kyrgyzstan).
*/
public val Emoji.Companion.KyrgyzstanFlag: Emoji get() = _FlagKyrgyzstan
