package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagMadagascar: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇲🇬",
        description = "flag: Madagascar",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-madagascar", "madagascar-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Madagascar.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagMadagascar: Emoji get() = _FlagMadagascar

/**
 * Alias to emoji [FlagMadagascar] (Flags: country-flag: flag: Madagascar).
*/
public val Emoji.Companion.MadagascarFlag: Emoji get() = _FlagMadagascar
