package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagTurkmenistan: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇹🇲",
        description = "flag: Turkmenistan",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-turkmenistan", "turkmenistan-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Turkmenistan.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagTurkmenistan: Emoji get() = _FlagTurkmenistan

/**
 * Alias to emoji [FlagTurkmenistan] (Flags: country-flag: flag: Turkmenistan).
*/
public val Emoji.Companion.TurkmenistanFlag: Emoji get() = _FlagTurkmenistan
