package org.kodein.emoji.flags.subdivision_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagWales: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🏴󠁧󠁢󠁷󠁬󠁳󠁿",
        description = "flag: Wales",
        unicodeVersion = UnicodeVersion(5, 0),
        aliases = listOf("flag-wales", "wales-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: subdivision-flag: flag: Wales.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagWales: Emoji get() = _FlagWales

/**
 * Alias to emoji [FlagWales] (Flags: subdivision-flag: flag: Wales).
*/
public val Emoji.Companion.WalesFlag: Emoji get() = _FlagWales
