package org.kodein.emoji.food_drink.food_asian

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllFoodAsian() {
    add(intArrayOf(0x1f360), _RoastedSweetPotato)
    add(intArrayOf(0x1f35d), _Spaghetti)
    add(intArrayOf(0x1f35b), _CurryRice)
    add(intArrayOf(0x1f35c), _SteamingBowl)
    add(intArrayOf(0x1f363), _Sushi)
    add(intArrayOf(0x1f364), _FriedShrimp)
    add(intArrayOf(0x1f961), _TakeoutBox)
    add(intArrayOf(0x1f35a), _CookedRice)
    add(intArrayOf(0x1f371), _BentoBox)
    add(intArrayOf(0x1f95f), _Dumpling)
    add(intArrayOf(0x1f362), _Oden)
    add(intArrayOf(0x1f359), _RiceBall)
    add(intArrayOf(0x1f358), _RiceCracker)
    add(intArrayOf(0x1f365), _FishCakeWithSwirl)
    add(intArrayOf(0x1f361), _Dango)
    add(intArrayOf(0x1f960), _FortuneCookie)
    add(intArrayOf(0x1f96e), _MoonCake)
}

internal fun MutableList<Emoji>.addAllFoodAsian() {
    add(_RoastedSweetPotato)
    add(_Spaghetti)
    add(_CurryRice)
    add(_SteamingBowl)
    add(_Sushi)
    add(_FriedShrimp)
    add(_TakeoutBox)
    add(_CookedRice)
    add(_BentoBox)
    add(_Dumpling)
    add(_Oden)
    add(_RiceBall)
    add(_RiceCracker)
    add(_FishCakeWithSwirl)
    add(_Dango)
    add(_FortuneCookie)
    add(_MoonCake)
}

/**
 * All Emoji of the Food & Drink: food-asian subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allFoodAsian(): List<Emoji> =
    ArrayList<Emoji>(17).apply { addAllFoodAsian() }
