package org.kodein.emoji.objects.mail

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _OpenMailboxWithRaisedFlag: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "📬",
        description = "open mailbox with raised flag",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("open-mailbox-with-raised-flag", "open-mailbox-with-raised"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: mail: open mailbox with raised flag.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.OpenMailboxWithRaisedFlag: Emoji get() = _OpenMailboxWithRaisedFlag

/**
 * Alias to emoji [OpenMailboxWithRaisedFlag] (Objects: mail: open mailbox with raised flag).
*/
public val Emoji.Companion.OpenMailboxWithRaised: Emoji get() = _OpenMailboxWithRaisedFlag
