package org.kodein.emoji.people_body.family

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone2Emoji
import org.kodein.emoji.SkinTone2EmojiZWJImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _WomanAndManHoldingHands: SkinTone2Emoji = SkinTone2EmojiZWJImpl(
    details = Emoji.Details(
        string = "👫",
        description = "woman and man holding hands",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("woman-and-man-holding-hands", "holding-hands-woman-and-man"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
    sk1c = 2,
    zwjTemplate = "👩‍🤝‍👨",
    zwjUnicodeVersion = UnicodeVersion(12, 0),
    sk21c = 2,
    sk22c = 8,
)

/**
 * Emoji People & Body: family: woman and man holding hands.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.WomanAndManHoldingHands: SkinTone2Emoji get() = _WomanAndManHoldingHands

/**
 * Alias to emoji [WomanAndManHoldingHands] (People & Body: family: woman and man holding hands).
*/
public val Emoji.Companion.HoldingHandsWomanAndMan: SkinTone2Emoji get() = _WomanAndManHoldingHands
