package org.kodein.emoji.people_body.person_sport

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _PeopleWrestling: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🤼",
        description = "people wrestling",
        unicodeVersion = UnicodeVersion(3, 0),
        aliases = listOf("people-wrestling", "wrestling"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji People & Body: person-sport: people wrestling.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PeopleWrestling: Emoji get() = _PeopleWrestling

/**
 * Alias to emoji [PeopleWrestling] (People & Body: person-sport: people wrestling).
*/
public val Emoji.Companion.Wrestling: Emoji get() = _PeopleWrestling
