package org.kodein.emoji.smileys_emotion.face_smiling

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _WinkingFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😉",
        description = "winking face",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("winking-face", "wink"),
        emoticons = listOf(";)"),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-smiling: winking face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.WinkingFace: Emoji get() = _WinkingFace

/**
 * Alias to emoji [WinkingFace] (Smileys & Emotion: face-smiling: winking face).
*/
public val Emoji.Companion.Wink: Emoji get() = _WinkingFace
