package org.kodein.emoji.symbols.av_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _AntennaBars: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "📶",
        description = "antenna bars",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("antenna-bars", "signal-strength"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: av-symbol: antenna bars.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.AntennaBars: Emoji get() = _AntennaBars

/**
 * Alias to emoji [AntennaBars] (Symbols: av-symbol: antenna bars).
*/
public val Emoji.Companion.SignalStrength: Emoji get() = _AntennaBars
