package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagFinland: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇫🇮",
        description = "flag: Finland",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-finland", "finland-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Finland.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagFinland: Emoji get() = _FlagFinland

/**
 * Alias to emoji [FlagFinland] (Flags: country-flag: flag: Finland).
*/
public val Emoji.Companion.FinlandFlag: Emoji get() = _FlagFinland
