package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagMauritius: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇲🇺",
        description = "flag: Mauritius",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-mauritius", "mauritius-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Mauritius.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagMauritius: Emoji get() = _FlagMauritius

/**
 * Alias to emoji [FlagMauritius] (Flags: country-flag: flag: Mauritius).
*/
public val Emoji.Companion.MauritiusFlag: Emoji get() = _FlagMauritius
