package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagPapuaNewGuinea: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇵🇬",
        description = "flag: Papua New Guinea",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-papua-new-guinea", "papua-new-guinea-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Papua New Guinea.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagPapuaNewGuinea: Emoji get() = _FlagPapuaNewGuinea

/**
 * Alias to emoji [FlagPapuaNewGuinea] (Flags: country-flag: flag: Papua New Guinea).
*/
public val Emoji.Companion.PapuaNewGuineaFlag: Emoji get() = _FlagPapuaNewGuinea
