package org.kodein.emoji.objects.clothing

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _HikingBoot: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🥾",
        description = "hiking boot",
        unicodeVersion = UnicodeVersion(11, 0),
        aliases = listOf("hiking-boot", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: clothing: hiking boot.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.HikingBoot: Emoji get() = _HikingBoot
