package org.kodein.emoji.objects.clothing

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _ShoppingBags: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🛍️",
        description = "shopping bags",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("shopping-bags", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: clothing: shopping bags.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ShoppingBags: Emoji get() = _ShoppingBags
