package org.kodein.emoji.objects.clothing

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllClothing() {
    add(intArrayOf(0x1fa70), _BalletShoes)
    add(intArrayOf(0x1fa71), _OnePieceSwimsuit)
    add(intArrayOf(0x1f3a9), _TopHat)
    add(intArrayOf(0x1f6cd, 0xfe0f), _ShoppingBags)
    add(intArrayOf(0x1f6cd), _ShoppingBags)
    add(intArrayOf(0x1faae), _HairPick)
    add(intArrayOf(0x1f9e6), _Socks)
    add(intArrayOf(0x1f9e4), _Gloves)
    add(intArrayOf(0x1f9e3), _Scarf)
    add(intArrayOf(0x1f456), _Jeans)
    add(intArrayOf(0x1f455), _TShirt)
    add(intArrayOf(0x1f45a), _WomansClothes)
    add(intArrayOf(0x1f454), _Necktie)
    add(intArrayOf(0x1f457), _Dress)
    add(intArrayOf(0x1f458), _Kimono)
    add(intArrayOf(0x1f97b), _Sari)
    add(intArrayOf(0x1f459), _Bikini)
    add(intArrayOf(0x1fa73), _Shorts)
    add(intArrayOf(0x1fa72), _Briefs)
    add(intArrayOf(0x1f9e5), _Coat)
    add(intArrayOf(0x1f97c), _LabCoat)
    add(intArrayOf(0x1f9ba), _SafetyVest)
    add(intArrayOf(0x26d1, 0xfe0f), _RescueWorkersHelmet)
    add(intArrayOf(0x26d1), _RescueWorkersHelmet)
    add(intArrayOf(0x1fa96), _MilitaryHelmet)
    add(intArrayOf(0x1f393), _GraduationCap)
    add(intArrayOf(0x1f452), _WomansHat)
    add(intArrayOf(0x1f9e2), _BilledCap)
    add(intArrayOf(0x1f451), _Crown)
    add(intArrayOf(0x1faad), _FoldingHandFan)
    add(intArrayOf(0x1f392), _Backpack)
    add(intArrayOf(0x1f45d), _ClutchBag)
    add(intArrayOf(0x1f45b), _Purse)
    add(intArrayOf(0x1f45c), _Handbag)
    add(intArrayOf(0x1f48d), _Ring)
    add(intArrayOf(0x1f48e), _GemStone)
    add(intArrayOf(0x1f484), _Lipstick)
    add(intArrayOf(0x1f460), _HighHeeledShoe)
    add(intArrayOf(0x1f45f), _RunningShoe)
    add(intArrayOf(0x1f45e), _MansShoe)
    add(intArrayOf(0x1f97f), _FlatShoe)
    add(intArrayOf(0x1fa74), _ThongSandal)
    add(intArrayOf(0x1f461), _WomansSandal)
    add(intArrayOf(0x1f462), _WomansBoot)
    add(intArrayOf(0x1f97e), _HikingBoot)
    add(intArrayOf(0x1f576, 0xfe0f), _Sunglasses)
    add(intArrayOf(0x1f576), _Sunglasses)
    add(intArrayOf(0x1f453), _Glasses)
    add(intArrayOf(0x1f97d), _Goggles)
    add(intArrayOf(0x1f4ff), _PrayerBeads)
}

internal fun MutableList<Emoji>.addAllClothing() {
    add(_BalletShoes)
    add(_OnePieceSwimsuit)
    add(_TopHat)
    add(_ShoppingBags)
    add(_HairPick)
    add(_Socks)
    add(_Gloves)
    add(_Scarf)
    add(_Jeans)
    add(_TShirt)
    add(_WomansClothes)
    add(_Necktie)
    add(_Dress)
    add(_Kimono)
    add(_Sari)
    add(_Bikini)
    add(_Shorts)
    add(_Briefs)
    add(_Coat)
    add(_LabCoat)
    add(_SafetyVest)
    add(_RescueWorkersHelmet)
    add(_MilitaryHelmet)
    add(_GraduationCap)
    add(_WomansHat)
    add(_BilledCap)
    add(_Crown)
    add(_FoldingHandFan)
    add(_Backpack)
    add(_ClutchBag)
    add(_Purse)
    add(_Handbag)
    add(_Ring)
    add(_GemStone)
    add(_Lipstick)
    add(_HighHeeledShoe)
    add(_RunningShoe)
    add(_MansShoe)
    add(_FlatShoe)
    add(_ThongSandal)
    add(_WomansSandal)
    add(_WomansBoot)
    add(_HikingBoot)
    add(_Sunglasses)
    add(_Glasses)
    add(_Goggles)
    add(_PrayerBeads)
}

/**
 * All Emoji of the Objects: clothing subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allClothing(): List<Emoji> =
    ArrayList<Emoji>(47).apply { addAllClothing() }
