package org.kodein.emoji.objects.mail

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _ClosedMailboxWithLoweredFlag: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "📪",
        description = "closed mailbox with lowered flag",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("closed-mailbox-with-lowered-flag", "closed-mailbox-with-lowered"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: mail: closed mailbox with lowered flag.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ClosedMailboxWithLoweredFlag: Emoji get() = _ClosedMailboxWithLoweredFlag

/**
 * Alias to emoji [ClosedMailboxWithLoweredFlag] (Objects: mail: closed mailbox with lowered flag).
*/
public val Emoji.Companion.ClosedMailboxWithLowered: Emoji get() = _ClosedMailboxWithLoweredFlag
