package org.kodein.emoji.objects.tool

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _HammerAndWrench: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🛠️",
        description = "hammer and wrench",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("hammer-and-wrench", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: tool: hammer and wrench.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.HammerAndWrench: Emoji get() = _HammerAndWrench
