package org.kodein.emoji.people_body.person_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _BustInSilhouette: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "👤",
        description = "bust in silhouette",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("bust-in-silhouette", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji People & Body: person-symbol: bust in silhouette.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BustInSilhouette: Emoji get() = _BustInSilhouette
