package org.kodein.emoji.smileys_emotion.heart

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _TwoHearts: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "💕",
        description = "two hearts",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("two-hearts", ),
        emoticons = listOf("<3<3"),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: heart: two hearts.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.TwoHearts: Emoji get() = _TwoHearts
