package org.kodein.emoji.smileys_emotion.heart

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllHeart() {
    add(intArrayOf(0x2764, 0xfe0f), _RedHeart)
    add(intArrayOf(0x2764), _RedHeart)
    add(intArrayOf(0x1f9e1), _OrangeHeart)
    add(intArrayOf(0x1f49b), _YellowHeart)
    add(intArrayOf(0x1f49a), _GreenHeart)
    add(intArrayOf(0x1fa75), _LightBlueHeart)
    add(intArrayOf(0x1f499), _BlueHeart)
    add(intArrayOf(0x1f49c), _PurpleHeart)
    add(intArrayOf(0x1f90e), _BrownHeart)
    add(intArrayOf(0x1f5a4), _BlackHeart)
    add(intArrayOf(0x1fa76), _GreyHeart)
    add(intArrayOf(0x1f90d), _WhiteHeart)
    add(intArrayOf(0x1fa77), _PinkHeart)
    add(intArrayOf(0x1f498), _HeartWithArrow)
    add(intArrayOf(0x1f49d), _HeartWithRibbon)
    add(intArrayOf(0x1f496), _SparklingHeart)
    add(intArrayOf(0x1f497), _GrowingHeart)
    add(intArrayOf(0x1f493), _BeatingHeart)
    add(intArrayOf(0x1f49e), _RevolvingHearts)
    add(intArrayOf(0x1f495), _TwoHearts)
    add(intArrayOf(0x1f48c), _LoveLetter)
    add(intArrayOf(0x1f49f), _HeartDecoration)
    add(intArrayOf(0x2763, 0xfe0f), _HeartExclamation)
    add(intArrayOf(0x2763), _HeartExclamation)
    add(intArrayOf(0x2764, 0xfe0f, 0x200d, 0x1fa79), _MendingHeart)
    add(intArrayOf(0x2764, 0x200d, 0x1fa79), _MendingHeart)
    add(intArrayOf(0x1f494), _BrokenHeart)
    add(intArrayOf(0x2764, 0xfe0f, 0x200d, 0x1f525), _HeartOnFire)
    add(intArrayOf(0x2764, 0x200d, 0x1f525), _HeartOnFire)
}

internal fun MutableList<Emoji>.addAllHeart() {
    add(_RedHeart)
    add(_OrangeHeart)
    add(_YellowHeart)
    add(_GreenHeart)
    add(_LightBlueHeart)
    add(_BlueHeart)
    add(_PurpleHeart)
    add(_BrownHeart)
    add(_BlackHeart)
    add(_GreyHeart)
    add(_WhiteHeart)
    add(_PinkHeart)
    add(_HeartWithArrow)
    add(_HeartWithRibbon)
    add(_SparklingHeart)
    add(_GrowingHeart)
    add(_BeatingHeart)
    add(_RevolvingHearts)
    add(_TwoHearts)
    add(_LoveLetter)
    add(_HeartDecoration)
    add(_HeartExclamation)
    add(_MendingHeart)
    add(_BrokenHeart)
    add(_HeartOnFire)
}

/**
 * All Emoji of the Smileys & Emotion: heart subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allHeart(): List<Emoji> =
    ArrayList<Emoji>(25).apply { addAllHeart() }
