package org.kodein.emoji.symbols.alphanum

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _JapaneseApplicationButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🈸",
        description = "Japanese “application” button",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("japanese-application-button", "application"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: alphanum: Japanese “application” button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.JapaneseApplicationButton: Emoji get() = _JapaneseApplicationButton

/**
 * Alias to emoji [JapaneseApplicationButton] (Symbols: alphanum: Japanese “application” button).
*/
public val Emoji.Companion.Application: Emoji get() = _JapaneseApplicationButton
