package org.kodein.emoji.symbols.geometric

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _PurpleCircle: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🟣",
        description = "purple circle",
        unicodeVersion = UnicodeVersion(12, 0),
        aliases = listOf("purple-circle", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: geometric: purple circle.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PurpleCircle: Emoji get() = _PurpleCircle
