package org.kodein.emoji.symbols.keycap

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllKeycap() {
    add(intArrayOf(0x23, 0xfe0f, 0x20e3), _KeycapHash)
    add(intArrayOf(0x23, 0x20e3), _KeycapHash)
    add(intArrayOf(0x2a, 0xfe0f, 0x20e3), _KeycapStar)
    add(intArrayOf(0x2a, 0x20e3), _KeycapStar)
    add(intArrayOf(0x30, 0xfe0f, 0x20e3), _Keycap0)
    add(intArrayOf(0x30, 0x20e3), _Keycap0)
    add(intArrayOf(0x31, 0xfe0f, 0x20e3), _Keycap1)
    add(intArrayOf(0x31, 0x20e3), _Keycap1)
    add(intArrayOf(0x32, 0xfe0f, 0x20e3), _Keycap2)
    add(intArrayOf(0x32, 0x20e3), _Keycap2)
    add(intArrayOf(0x33, 0xfe0f, 0x20e3), _Keycap3)
    add(intArrayOf(0x33, 0x20e3), _Keycap3)
    add(intArrayOf(0x34, 0xfe0f, 0x20e3), _Keycap4)
    add(intArrayOf(0x34, 0x20e3), _Keycap4)
    add(intArrayOf(0x35, 0xfe0f, 0x20e3), _Keycap5)
    add(intArrayOf(0x35, 0x20e3), _Keycap5)
    add(intArrayOf(0x36, 0xfe0f, 0x20e3), _Keycap6)
    add(intArrayOf(0x36, 0x20e3), _Keycap6)
    add(intArrayOf(0x37, 0xfe0f, 0x20e3), _Keycap7)
    add(intArrayOf(0x37, 0x20e3), _Keycap7)
    add(intArrayOf(0x38, 0xfe0f, 0x20e3), _Keycap8)
    add(intArrayOf(0x38, 0x20e3), _Keycap8)
    add(intArrayOf(0x39, 0xfe0f, 0x20e3), _Keycap9)
    add(intArrayOf(0x39, 0x20e3), _Keycap9)
    add(intArrayOf(0x1f51f), _Keycap10)
}

internal fun MutableList<Emoji>.addAllKeycap() {
    add(_KeycapHash)
    add(_KeycapStar)
    add(_Keycap0)
    add(_Keycap1)
    add(_Keycap2)
    add(_Keycap3)
    add(_Keycap4)
    add(_Keycap5)
    add(_Keycap6)
    add(_Keycap7)
    add(_Keycap8)
    add(_Keycap9)
    add(_Keycap10)
}

/**
 * All Emoji of the Symbols: keycap subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allKeycap(): List<Emoji> =
    ArrayList<Emoji>(13).apply { addAllKeycap() }
